Attribute VB_Name = "SOM_lib"
Option Explicit


Public Const CL_COLOR_ENABLED As Long = &H80000005
Public Const CL_COLOR_DISABLED As Long = &H8000000F
Public Const CL_COLOR_LOCKED As Long = &H80000018

Private Const SEP As String = ""
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""


Public Enum eComponent
    eCustomer = 0
    eProject = 1
    eQuote = 2
    eExcelExp = 3
    eLink = 4
    eSavedSel = 5
    eNavig = 6
End Enum


Public Enum eMode
    emView = 0
    emAdd = 1
    emUpdate = 3
    emDelete = 4
    emRevision = 5
    emCopy = 6
End Enum


Public Enum eProjStatus
    eProjOrderPhase = 1
    eProjCancelled = 2
    eProjQuoteTender = 3
    eProjSpecification = 4
    eProjOnsite = 5
    eProjComplete = 6
End Enum

Private mb_IsFullAccess As Boolean


Public Property Get IsFullAccess() As Long
    IsFullAccess = mb_IsFullAccess
End Property





#If LIVE Then
Public Function Rights_Access(ByRef aDb As Object, ByVal aUcode As Long) As Boolean
#Else
Public Function Rights_Access(ByRef aDb As ArmDb, ByVal aUcode As Long) As Boolean
#End If
    Const Request As String = "SELECT G_code FROM SOM_AuthUsrs WHERE U_code = $U_code$"
    
    Dim ll_curs As Long
    Dim ls_req As String
    Static lb_HasRun As Boolean
    Static ll_group As Long
    
    
    If lb_HasRun = False Then
        ls_req = Replace(Request, "$U_code$", aUcode)
        
        ll_curs = aDb.OpenSQL(ls_req)
        
        If aDb.RowCount(ll_curs) <> 0 Then
            ll_group = aDb.GetFields(ll_curs, "G_code")
        End If
        
        Call aDb.Close(ll_curs)
        
        lb_HasRun = True
    End If
    
    If ll_group <> 0 Then
        If ll_group = 1 Then
            mb_IsFullAccess = True
        Else
            mb_IsFullAccess = False
        End If
        Rights_Access = True
    Else
        Rights_Access = False
    End If
    
    Exit Function

ErrHandler:
    Call aDb.Close(ll_curs)
    Call ErrorHandler("Rights_Access")
End Function

Private Sub ErrorHandler(ByVal as_Fct As String)
    Err.Raise Err.Number, "SOM_lib::" & as_Fct & SEP1 & Err.Source, Err.Description
End Sub
